<?php

class LogModel extends BaseModel
{
	public $id;
	public $character;
	public $list;
	public $user;
	public $command;
	public $comment;
	public $date;
	
	public function __construct($id = -1,$rel )
	{
		if(!is_numeric($id))
		{
			$this->trigerror("LogModel.construct (".__FILE__."): ID must be numeric.",E_USER_ERROR);
			return;
		}
		
		if($id == -1) return;
	}
	
	public static function getLog($from=0,$amount=20)
	{
		$db = Factory::getDBConnection();
		if(!is_numeric($from) || !is_numeric($amount))
		{
			trigger_error("getLog - invalid parameter. Form: '$from' - Amount: '$amount'",E_USER_ERROR);
			return NULL;
		}
		$sql = "SELECT id,user,command,list,character,comment,add_date FROM `char_list_log` LIMIT $from,$amount";
		if(($result = $db->query($sql)) == FALSE)
		{
			$this->trigerror("Log.getLog (".__FILE__.") - SQL query failed: $sql",E_USER_ERROR);
			return NULL;
		}
		
		$ret = array();
		
		while($res = $result->fetch_array(MYSQLI_NUM))
		{
			$log = new LogModel();
			$log->id = $res[0];
			$log->user = $res[1];
			$log->command = $res[2];
			$log->list = $res[3];
			$log->character = $res[4];
			$log->comment = $res[5];
			$log->date = $res[6];
			
			$ret[] = $log;
		}
		
		return $ret;
	}
	
	public function save()
	{
		
	}
	
}

?>
