<?php


class ListView{

	private $_model;

	public function __construct($listmodel){
		if(! ($listmodel instanceof ListModel)) trigger_error("Given Model is not an instance of \"ListModel\"",E_USER_ERROR);
		
		$this->_model = $listmodel;
	}
	
	
	public function showAll(){
		$cm = new ClassModel();
		
		if($this->_model->char_list === NULL)
			return;
		$ret = array();
		foreach($this->_model->char_list as $c)
		{			
			if($c->active == 1) $ret[] = array("char_id" => $c->character->id,
						"char_class" => $cm->getClass($c->character->class),
						"char_name" => $c->character->name);
		}
		return $ret;
	}
	
	public function getListName($displayAs){
		return $this->_model->name;
	}
	
	

}
