<?php

class ClassLoader{

	public function __construct(){
		spl_autoload_register(array($this,"load"));
		
		$this->addIncludePath("system/");
		$this->addIncludePath("list/");
		$this->addIncludePath("list/model/");
		$this->addIncludePath("list/view/");
		$this->addIncludePath("system/template");
	}
	
	private function addIncludePath($path){
		if(!empty($path) && file_exists($path)) set_include_path(get_include_path().PATH_SEPARATOR.$path);
		else trigger_error("IncludePath '".$path."' does not exist!");
	}
	
	private function load($classname){		
		spl_autoload_extensions('.class.php');
		spl_autoload($classname);
	}
}

$loader = new ClassLoader();

?>
