#include <stdio.h> 
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>

/*****************************************/
/*                                       */
/* Nils-SHELL                            */
/* My own Shell                          */
/* Calls programms etc.                  */
/*                                       */
/* Author: Nils Duschner                 */
/* Date: 2009/04/23                      */
/*****************************************/

#define MAXLINE 255
#define MAXPARAMS 30
#define MAXPIPES 1

void callchild(char* command, char** params);
int inShell(char* command,int parc,char** argv);
int parseParams(int parc,char** params);
void version();
void help();

int main(int argc,char** argv){
	int fildes[2];
	char linetype[MAXLINE]= {0};
	char* tpipe=NULL,*pipehelper=NULL;
	char* command[MAXPIPES+1] = {NULL};
	char* param=NULL;
	char* params[MAXPIPES+1][MAXPARAMS+1] = {{0}};
	char* pipesave[MAXLINE];
	char* paramsave[MAXLINE];
	char hostname[20];
	pid_t thispid[MAXPIPES+1];
	int i=0,pipes=0,cpipe=0,bpipe=0;
	size_t len=0;


	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'v') version();
	else if(argc > 1){ help(); exit(0); }

	gethostname(hostname,20);
	while(printf("%s@%s:%s$ ",getenv("USER"),hostname,getcwd(NULL,0)) && fgets(linetype,MAXLINE,stdin) != NULL){
		len = strlen(linetype); linetype[len-1] = '\0';
		pipes=cpipe=0;
		pipehelper = linetype;
		for(i=0;i<len;i++) if(linetype[i] == '|') pipes++;
		if(pipes > MAXPIPES){
			printf("Commands with more than %i pipe(s) are currently not supported!",MAXPIPES);
			continue;
		}
		printf("Pipes: %i\n",pipes);
		printf("LineType/PipeHelper: %s\n",pipehelper);
		while((tpipe = strtok_r(pipehelper,"|",pipesave)) != NULL){ // DO FOR EVERY "PIPE" - ATM LIMITED TO 1
			i=0;
			pipehelper=NULL;
			printf("Init Params\n");
			for(i=0;i<MAXPARAMS;i++) params[cpipe][i] = NULL;
			printf("Pipe: %s\n",tpipe);
			i=0;
			while((param=strtok_r(tpipe," \t\n",paramsave))!=NULL&&i<MAXPARAMS){ // EXPLODE PARAMS INTO AN ARRAY incl. command
				tpipe=NULL;
				params[cpipe][i++] = param;
			}
			parseParams(i,params[cpipe]);
			command[cpipe] = params[cpipe][0];
			cpipe++;
		}
		if(inShell(command[0],i,params[0]) == 0){ // IF COMMAND IS NOT EXECUTED SHELL-INTERN
			if(pipes > 0){ // IF THERE IS ANY PIPE CHAR AND A PIPE WAS NOT CREATED BEFORE: CREATE A PIPE
				if(pipe(fildes) < 0){
					printf("Error initializing pipe\n");
					exit(1);
				}
			}
			if(pipes>0){
				if((thispid[0] = fork()) == 0){ // FORK TO CHILD L
					if(dup2(fildes[1],STDOUT_FILENO) < 0){
						perror("DUP");
						exit(1);
					}
					close(fildes[0]);
				    
					callchild(command[0],params[0]);
				    exit(0);
				}
				else if((thispid[1] = fork()) == 0){ /* FORK TO CHILD R */
					if(dup2(fildes[0],STDIN_FILENO) < 0){
						perror("DUP");
						exit(1);
					}
					close(fildes[1]);
				    callchild(command[1],params[1]);
				    exit(0);
				}
				else if( thispid[0] <0 || thispid[1]<0){
					perror("fork");
					exit(1);
				}
				else{
					close(fildes[0]);
					close(fildes[1]);

					if(waitpid(thispid[0],NULL,0)<0){
						perror("waidpid");
						exit(1);
					}
					if(waitpid(thispid[1],NULL,0)<0){
						perror("waidpid");
						exit(1);
					}
				}
			}
			else if(pipes==0){
				if((thispid[0] = fork()) == 0){
				callchild(command[0],params[0]);
				exit(0);
				}
				if(waitpid(thispid[0],NULL,0) <0){
					perror("waitpid");
					exit(1);
				}
			}
		}
	}
	printf("exit\n");
	return 0;
}


/* function: callchild */
/* calls the actual "programm" which should be executed */
/* return nothing */
/* char* command (in): the programm to be executed */
/* char** params (in): the params to programm in execvp format */
void callchild(char* command,char** params){
	execvp(command,params);
	if(errno != 0) perror("Child Error");
	errno=0;
	return;
}


/* Function: inShell */
/* Figure out wether command should be executed "inShell" rather than execv */
/* returns 0 if command needs to be executeded as child, otherwise 1 */
/* char* command (in): which command was "typed" */
/* int parc (in): param counter */
/* char** params (in): array of parameters */
int inShell(char* command,int parc,char** params){
	if(strcmp("exit",command) == 0) exit(0);
	else if(strcmp("cd",command) == 0){
		chdir(params[1]);
		if(errno!=0) perror("Command error");
		errno=0;
		return 1;
	}
	else if(strcmp("help",command) == 0){
		help();
		return 1;
	}
	return 0;
}


/* Function parseParams */
/* Substitute Variables (from ENV) by their actually value */
/* returns amount of parameters substituted */
/* int parc (in): param counter */
/* char ** params (in/out): the params */
int parseParams(int parc,char** params){
	int x,c=0;
	char* var;
	for(x=0;x<parc;x++){
		if(params[x] != NULL && params[x][0]=='$'){
			var = getenv(&params[x][1]);
			if(var != NULL){
				params[x] = var;
				c++;
			}
		}
	}
	return c;
}


void version(){
	printf("This is NSHELL in Version 1.0\n\nAuthor: Nils Duschner\nEmail: nils.duschner@fh-osnabrueck.de\n");
	help();
	exit(0);
}

void help(){
	printf("This Version of NSHELL does NOT support any parameters\n");
}
